<?php

require_once 'DatabasePDO.php';
require_once 'core/Constants.php';
require_once 'models/User.php';
require_once 'models/Friend.php';
require_once 'models/Guest.php';
require_once 'models/ResponsibleGuest.php';
require_once 'models/Event.php';
require_once 'models/EventGrillable.php';
require_once 'models/Category.php';
require_once 'models/Post.php';
require_once 'models/Location.php';
require_once 'FireBaseInterface.php';

header('Content-type: application/json');

//$f = new FireBaseInterface();
//print_r($f->sendMessage());

$db = new DatabasePDO();

//print_r($db->getAllPostToken(4));
//die;
$p = new Post();
$p->user_id = 'intolerant';
$p->message = 'Message1';
$p->event_id = 2;
//$db->addPost($p);
//$f = new FireBaseInterface();
//print_r($f->sendMessage());
//die;
//if ($_POST['action'] == "1") {
//	echo "Ist so";
//}

if (isset($_POST)) {
/*    if ($_POST['action'] == Constants::ACTION_LOGIN . '') {
	$user = $db->getUserLogin($_POST['username'], $_POST['password']);
	if ($user != null) {
	    echo json_encode($user, JSON_PRETTY_PRINT);
	} else {
	    echo $user;
	}
    }*/
switch ($_POST['action']) {
    case Constants::ACTION_REGISTER_USER:
        $user = new User();
        $user->username = $_POST['username'];
        $user->password = $_POST['password'];        
	$user->picture_url = "";
        echo $db->addUser($user);
        break;
    case Constants::ACTION_LOGIN:
        $user = new User();
        $user->username = $_POST['username'];
        $user->password = $_POST['password'];
        $user = $db->getUserLogin($user->username, $user->password);
        if ($user != null) {
            echo json_encode($user, JSON_PRETTY_PRINT);
        } else {
            echo $user;
        }
        break;
    case Constants::ACTION_EDIT_PROFILE:
        $user = json_decode($_POST['user']);
	savePicture("user", $user->picture_url, $user->user_id);
	$user->picture_url = $user->user_id;
        echo $db->editUser($user);
        break;
    case Constants::ACTION_ADD_FRIEND:
        $userID = $_POST['user_id'];
        $friendID = $_POST['friend_id'];
	echo $db->addFriend($userID, $friendID);
	$user = $db->getUserByID($userID);
	$friend = $db->getUserByID($friendID);
	$fb = new FireBaseInterface();
	$fb->sendFriend($user, $friend->token);
/*        $friend = $db->getFriend($userID, $friendID);
        if ($friend == null) {
            $db->addFriend($userID, $friendID);
        }*/
        break;
    case Constants::ACTION_CHANGE_FRIEND_STATUS:
        $user_id = $_POST['user_id'];
        $friend_id = $_POST['friend_id'];
        $status = $_POST['status'];
	$message = 0;
        if ($status == 2) {
            $message = $db->confirmFriend($user_id, $friend_id);
        } else if ($status == 0) {
            $message = $db->deleteFriend($user_id, $friend_id);
        }
	if ($message > 0) {
	    echo Constants::DB_QUERY_SUCCESS;
	} else {
    	    echo Constants::DB_QUERY_ERROR;
	}
        break;
    case Constants::ACTION_GET_MY_CONFIRMED_FRIENDS:
        $ownID = $_POST['user_id'];
        echo json_encode($db->getConfirmedFriends($ownID), JSON_PRETTY_PRINT);
        break;
    case Constants::ACTION_GET_MY_UNCONFIRMED_FRIENDS:
        $ownID = $_POST['user_id'];
        echo json_encode($db->getUnconfirmedFriends($ownID), JSON_PRETTY_PRINT);
        break;
    case Constants::ACTION_ADD_EVENT:
        $event = json_decode($_POST['event']);
	//print_r($event);
	//die;
	savePicture("event", $event->event_picture_url, $event->user_id . "_" . $event->date);
	$event->event_picture_url = $event->user_id . "_" . $event->date;
        echo $db->addEvent($event);
        break;
    case Constants::ACTION_INVITE_TO_EVENT:
        $event_id = $_POST['event_id'];
        $guestlist = json_decode($_POST['guestlist']);
        $invited_by = $_POST['invited_by'];
	foreach ($guestlist as $guest) {
	    $db->inviteFriendToEvent($event_id, $guest->user_id, $invited_by);
	    /*if ($success == 0) {
		echo Constants::DB_QUERY_ERROR;
		break;
	    }*/
	}
	$event = $db->getSingleEvent($event_id);
        $token = $db->getAllPostToken($event_id);
        $fb = new FireBaseInterface();
        $fb->sendEvent($event, $token);
        echo Constants::DB_QUERY_SUCCESS;
        break;
    case Constants::ACTION_GET_ALL_CATEGORY:
        //print_r($db->getAllCategory());
        $te = $db->getAllCategory();
        echo (json_encode($te, JSON_PRETTY_PRINT));
        break;
    case Constants::ACTION_PUT_GRILLABLE_TO_EVENT:
        $eGrillableList = json_decode($_POST['event_grillablelist']);
	$eventID = 0;
	foreach ($eGrillableList as $eGrillable) {
	    $db->addGrillableToEvent($eGrillable);
	    $eventID = $eGrillable->event_id;
	}
	$event = $db->getEventByID($eventID);
	if ($event->is_private == 1) {
    	    $event->username = $db->getUsernameByID($event->user_id);
	    $token = $db->getAllPostToken($eventID, $event->user_id);
	    $fb = new FireBaseInterface();
	    $fb->sendGrillable($event, $token);
	}
        echo Constants::DB_QUERY_SUCCESS;
        break;
    case Constants::ACTION_ADD_RESPONSIBLE_GUEST:
        $rGuest = json_decode($_POST['responsible_guest']);
        $rGuest->event_id = $_POST['event_id'];
        echo $db->addResponsibleGuest($rGuest);
        break;  
    case Constants::ACTION_GET_ALL_USER_EVENTS:
        $user_id = $_POST['user_id'];
        echo json_encode($db->getAllEventsFromUserByID($user_id), JSON_PRETTY_PRINT);
        break;
    case Constants::ACTION_CHANGE_GUEST_STATUS:
        $event_id = $_POST['event_id'];
        $user_id = $_POST['user_id'];
        $status = $_POST['status'];
        echo $db->changeGuestStatus($event_id, $user_id, $status);
        break;
    case Constants::ACTION_GET_PINBOARD:
	$eventID = $_POST['event_id'];
	echo json_encode($db->getPinboard($eventID), JSON_PRETTY_PRINT);
        break;
    case Constants::ACTION_ADD_PINBOARD_MESSAGE:
	$post = json_decode($_POST['post']);
	echo $db->addPost($post);
        break;
    case Constants::ACTION_SEARCH_USER:
        $username = $_POST['username'];
        echo json_encode($db->getUserByUsername($username), JSON_PRETTY_PRINT);
        break;
    case Constants::ACTION_GET_SINGLE_EVENT:
        $event_id = $_POST['event_id'];
        echo json_encode($db->getSingleEvent($event_id), JSON_PRETTY_PRINT);
        break;
    case Constants::ACTION_DELETE_GUEST:
	$eventID = $_POST['event_id'];
	$guestID = $_POST['guest_id'];
	echo $db->deleteGuestFromEvent($eventID, $guestID);
	break;
    case Constants::ACTION_DELETE_GRILLABLE:
	$eventID = $_POST['event_id'];
	$grillableID = $_POST['grillable_id'];
	echo $db->deleteGrillableFromEvent($eventID, $grillableID);
	break;
    case Constants::ACTION_DELETE_EVENT:
	$eventID = $_POST['event_id'];
	echo $db->deleteEvent($eventID);
	break;
    case Constants::ACTION_CHECK_NEW_EVENT:
	$userID = $_POST['user_id'];
	$lastCheck = $_POST['last_check'];
	$newEvents = $db->checkNewEvents($userID, $lastCheck);
	echo json_encode($newEvents, JSON_PRETTY_PRINT);
	break;
    case Constants:: ACTION_CHECK_NEW_FRIEND:
	$userID = $_POST['user_id'];
	$lastCheck = $_POST['last_check'];
	$newFriends = $db->checkNewFriends($userID, $lastCheck);
	echo json_encode($newFriends, JSON_PRETTY_PRINT);
//echo($newFriends);
	break;
    case Constants::ACTION_SAVE_TOKEN:
	$userID = $_POST['userID'];
	$token = $_POST['token'];
	echo $db->saveToken($userID, $token);
	break;
    }
} else {
echo "No Posts";
}


function savePicture($directory, $encodedImage, $fileURL) {
    $base = $encodedImage;
    // Get file name posted from Android App
    $filename = $fileURL;
    // Decode Image
    $binary = base64_decode($base);
    if (!is_dir('uploads')) {
        mkdir('uploads');
    }

    //$pathArray = explode("/", $filename);
    $path = 'uploads/' . $directory;
    if (!is_dir($path)) {
        mkdir($path);
    }

    $fullURL = $path . "/" . $filename;

    // Images will be saved under 'agrill//uploads/event' folder
    $file = fopen($fullURL . '.jpg', 'wb');
    // Create File
    fwrite($file, $binary);
    fclose($file);
    //echo 'Image upload complete, Please check your php file directory';

}
