<?php

/**
 * Description of DatabasePDO
 *
 * @author into
 */
// Datenbank Verbindung. Treiber, user, passwort und DB festlegen.
define('MYSQL_HOST', 'localhost');
define('MYSQL_BENUTZER', 'grill');
define('MYSQL_KENNWORT', 'grill1302');
define('MYSQL_DATENBANK', 'grill');

class DatabasePDO {

    private $db;

    function __construct() {
        try {
            $this->db = new PDO('mysql:host=' . MYSQL_HOST . ';dbname=' . MYSQL_DATENBANK . ';charset=utf8', MYSQL_BENUTZER, MYSQL_KENNWORT);
            $options = array(
                PDO::ATTR_PERSISTENT => true,
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            );
            $this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            print "Error!: " . $e->getMessage() . "<br/>";
            die();
        }
    }

    public function addUser($user) {
        try {
            if ($this->usernameExist($user->username)) {
                return Constants::USERNAME_EXISTS;
            }
            $stm = $this->db->prepare('INSERT INTO user (username, password, picture_url, added_at) VALUES (:username, :password, :picture_url, :added_at)');
            $datetime = new DateTime();
            $params = array(':username' => $user->username, ':password' => $user->password, ':picture_url' => $user->picture_url, ':added_at' => $datetime->format('Y-m-d H:i:s'));
            $stm->execute($params);
            return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $e) {
            echo $e->getMessage();
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function editUser($user) {
        try {
            if ($this->usernameExist($user->username) && $this->getUserIDByUsername($user->username) != $user->user_id) {
                return Constants::USERNAME_EXISTS;
            }
            $stm = $this->db->prepare('UPDATE user SET username=:username, picture_url=:picture_url WHERE user_id=:userID');
            $params = array(':username' => $user->username, ':picture_url' => $user->picture_url, ':userID' => $user->user_id);
            $stm->execute($params);
            return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $e) {
            echo $e->getMessage();
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function usernameExist($username) {
        $stm = $this->db->prepare('SELECT count(username) FROM user WHERE username=:username');
        $params = array(':username' => $username);
        $stm->execute($params);
        $usernameCount = $stm->fetch(0)[0];
        if ($usernameCount > 0) {
            return true;
        }
        return false;
    }

    public function getUser($id) {
        $stm = $this->db->prepare('SELECT user_id, username, picture_url FROM user WHERE user_id=:id');
        $params = array(':id' => $id);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'User');
        $stm->execute($params);
        $user = $stm->fetch(PDO::FETCH_CLASS);
        return $user;
    }

    public function getUserByUsername($username) {
        $stm = $this->db->prepare('SELECT user_id, username, picture_url, added_at FROM user WHERE username=:username');
        $params = array(':username' => $username);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'User');
        $stm->execute($params);
        $user = $stm->fetch(PDO::FETCH_CLASS);
        return $user;
    }

    public function getUsernameByID($id) {
        $stm = $this->db->prepare('SELECT username FROM user WHERE user_id=:id');
        $params = array(':id' => $id);
        $stm->execute($params);
        $username = $stm->fetch(0)[0];
        return $username;
    }

    public function getUserIDByUsername($username) {
        $stm = $this->db->prepare('SELECT user_id FROM user WHERE username=:username');
        $params = array(':username' => $username);
        $stm->execute($params);
        $userID = $stm->fetch(0)[0];
        return $userID;
    }

    public function getUserLogin($username, $password) {
        $stm = $this->db->prepare('SELECT user_id, username, picture_url, added_at, token  FROM user WHERE username=:username AND password=:password');
        $params = array(':username' => $username, ':password' => $password);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'User');
        $stm->execute($params);
        $user = $stm->fetch(PDO::FETCH_CLASS);
        return $user;
    }

    public function getConfirmedFriends($userID) {
        $stm = $this->db->prepare('SELECT * FROM friends WHERE (user_id=:userID OR friend_id=:userID) AND status=2');
        $params = array(':userID' => $userID);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'Friend');
        $stm->execute($params);
        $allUser = $stm->fetchAll(PDO::FETCH_CLASS);
        $allFriends = null;
        if ($allUser != null) {
            foreach ($allUser as $user) {
                if ($user->user_id == $userID) {
                    $id = $user->friend_id;
                } else {
                    $id = $user->user_id;
                }
                $friend = $this->getUser($id);
                $friend->status = 2;
                $allFriends[] = $friend;
            }
        }
        return $allFriends;
    }

    public function getUnconfirmedFriends($friendID) {
        $stm = $this->db->prepare('SELECT * FROM friends WHERE friend_id=:friendID AND status=1');
        $params = array(':friendID' => $friendID);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'Friends');
        $stm->execute($params);
        $allUser = $stm->fetchAll(PDO::FETCH_CLASS);
        $allFriends = null;
        if ($allUser != null) {
            foreach ($allUser as $user) {
                $friend = $this->getUser($user->user_id);
                $friend->status = 1;
                $allFriends[] = $friend;
            }
        }
        return $allFriends;
    }

    public function deleteFriend($ownID, $friendID) {
        try {
            $stm = $this->db->prepare('DELETE FROM friends WHERE (user_id=:userID AND friend_id=:friendID) OR (user_id=:friendID AND friend_id=:userID)');
            $params = array(':userID' => $ownID, 'friendID' => $friendID);
            $stm->execute($params);
            return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function getFriend($userID, $friendID) {
        $stm = $this->db->prepare('SELECT DISTINCT * FROM friends WHERE (user_id=:userID AND friend_id=:friendID) OR (user_id=:friendID AND friend_id=:userID)');
        $params = array(':userID' => $userID, ':friendID' => $friendID);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'Friend');
        $stm->execute($params);
        $allUser = $stm->fetch(PDO::FETCH_CLASS);
        $friend = null;
        if ($allUser != null) {
            $friend = $this->getUser($allUser->friend_id);
            $friend->status = 2;
        }
        return $friend;
    }

    public function addFriend($userID, $friendID) {
        if ($this->getFriend($userID, $friendID) == null) {
            try {
                $stm = $this->db->prepare('INSERT INTO friends (user_id, friend_id) VALUES (:userID, :friendID)');
                $params = array(':userID' => $userID, ':friendID' => $friendID);
                $stm->execute($params);
                return Constants::DB_QUERY_SUCCESS;
            } catch (Exception $e) {
                return Constants::DB_QUERY_ERROR;
            }
        } else {
            return Constants::FRIEND_EXISTS;
        }
    }

    public function confirmFriend($ownID, $friendID) {
        try {
            $stm = $this->db->prepare('UPDATE friends SET status=2 WHERE user_id=:userID AND friend_id=:friendID');
            $params = array(':userID' => $friendID, ':friendID' => $ownID);
            $stm->execute($params);
            return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function addLocation($latitude, $longitude) {
	try {
            $stm = $this->db->prepare('INSERT INTO event_location (latitude, longitude) VALUES (:latitude, :longitude)');
            $params = array(':latitude' => $latitude, ':longitude' => $longitude);
            $stm->execute($params);
            return $this->db->lastInsertId();
        } catch (Exception $ex) {
            return Constants::DB_QUERY_ERROR;
        }
    }

/*
    public function addEvent($event) {
        try {
	    $locationID = $this->addLocation($event->place->latitude, $event->place->longitude);
            $eventID = 0;
            $stm = $this->db->prepare('INSERT INTO event (date, place, title, picture_url, comment, is_private, added_by) VALUES (:date, :place, :title, :picture_url, :comment, :is_private, :added_by)');
            $params = array(':date' => date("y-m-d H:i:s", ($event->date / 1000)), ':place' => $locationID, ':title' => $event->title, ':picture_url' => $event->event_picture_url, ':comment' => $event->comment, ':is_private' => $event->is_private, ':added_by' => $event->user_id);
            $stm->execute($params);
            $eventID = $this->db->lastInsertId();
            $success = $this->addUserToEvent($eventID, $event->user_id, $event->user_id);
            if ($success == Constants::DB_QUERY_ERROR) {
                return Constants::DB_QUERY_ERROR;
            }
            return $eventID;
            //return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
		print_r($ex->getMessage());
            return Constants::DB_QUERY_ERROR;
        }
    }
*/

    public function addEvent($event) {
	$this->db->beginTransaction();
        try {
            $locationID = $this->addLocation($event->place->latitude, $event->place->longitude);
            $eventID = 0;
            $stm = $this->db->prepare('INSERT INTO event (date, place, title, picture_url, comment, is_private, added_by) VALUES (:date, :place, :title, :picture_url, :comment, :is_private, :added_by)');
	    $params = array(':date' => date("y-m-d H:i:s", ($event->date / 1000)), ':place' => $locationID, ':title' => $event->title, ':picture_url' => $event->event_picture_url, ':comment' => $event->comment, ':is_private' => $event->is_private, ':added_by' => $event->user_id);
            $stm->execute($params);
            $eventID = $this->db->lastInsertId();
            $success = $this->addUserToEvent($eventID, $event->user_id, $event->user_id);
	    foreach ($event->guestList as $guest) {
		$this->inviteFriendToEvent($eventID, $guest->user_id, $guest->invited_by);
	    }
	    foreach ($event->grillableList as $grillable) {
		$grillable->event_id = $eventID;
		$this->addGrillableToEvent($grillable); 
	    }
	    $this->db->commit();
            if ($success == Constants::DB_QUERY_ERROR) {
                return Constants::DB_QUERY_ERROR;
            }
//	    $event = $this->getSingleEvent($event_id);
            $token = $this->getAllPostToken($eventID, $event->user_id);
            $fb = new FireBaseInterface();
            $fb->sendEvent($event, $token);
            //return $eventID;
            return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
	    $this->db->rollBack();
                print_r($ex->getMessage());
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function deleteEvent($eventID) {
	try {
	    if ($this->deleteAllResponsibleGuestFromEvent($eventID)) {
		if ($this->deleteAllGrillableFromEvent($eventID)) {
		    $stm = $this->db->prepare('DELETE FROM event WHERE event_id=:eventID');
	            $params = array(':eventID' => $eventID);
        	    $stm->execute($params);
        	    return Constants::DB_QUERY_SUCCESS;
		}
	    }
            return Constants::DB_QUERY_ERROR;
        } catch (Exception $ex) {
                print_r($ex->getMessage());
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function deleteAllResponsibleGuestFromEvent($eventID) {
	try {
            $stm = $this->db->prepare('DELETE FROM responsible_guest WHERE event_id=:eventID');
            $params = array(':eventID' => $eventID);
            $stm->execute($params);
            if ($success == Constants::DB_QUERY_ERROR) {
                return Constants::DB_QUERY_ERROR;
            }
            return $eventID;
            //return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
                print_r($ex->getMessage());
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function deleteAllGrillableFromEvent($eventID) {
	try {
            $stm = $this->db->prepare('DELETE FROM event_grillable WHERE event_id=:eventID');
            $params = array(':eventID' => $eventID);
            $stm->execute($params);
            if ($success == Constants::DB_QUERY_ERROR) {
                return Constants::DB_QUERY_ERROR;
            }
            return $eventID;
            //return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
                print_r($ex->getMessage());
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function addUserToEvent($eventID, $userID, $invitedBy) {
        try {
            $stm = $this->db->prepare('INSERT INTO guestlist (user_id, event_id, invited_by, status) VALUES (:userID, :eventID, :invited_by, 3)');
            $params = array(':userID' => $userID, ':eventID' => $eventID, ':invited_by' => $invitedBy);
            $stm->execute($params);
            return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function getLocationByID($locationID) {
	$stm = $this->db->prepare('SELECT latitude, longitude FROM event_location WHERE location_id=:locationID');
	$params = array(':locationID' => $locationID);
	$stm->setFetchMode(PDO::FETCH_CLASS, 'Location');
	$stm->execute($params);
	$location = $stm->fetchAll();
	return $location[0];
    }

    public function getAllEventsFromUserByID($id) {
        $stm = $this->db->prepare('SELECT DISTINCT e.event_id, e.title, e.picture_url as event_picture_url, e.comment, (UNIX_TIMESTAMP(e.date) * 1000) as date, e.place, e.is_private, e.added_by as user_id, (UNIX_TIMESTAMP(e.date_added) * 1000) as added_at, u.username, u.picture_url as user_picture_url, u.user_id FROM event e, user u WHERE u.user_id=e.added_by AND (e.added_by=:userid or e.event_id in (SELECT event_id FROM guestlist WHERE user_id=:userid)) Order By date');
        $params = array(':userid' => $id);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'Event');
        $stm->execute($params);
        $allEvents = $stm->fetchAll(PDO::FETCH_CLASS);
        foreach ($allEvents as $event) {
//            $event->userAmount = $this->getCountUserFromEvent($event->id) + 1;
            $event->guestList = $this->getAllGuestFromEvent($event->event_id);
            $event->grillableList = $this->getAllGrillableFromEvent($event->event_id, $id);
	    $event->place = $this->getLocationByID($event->place);
        }
        //print_r($allEvents);
        return $allEvents;
    }

    public function getAllGuestFromEvent($id) {
        $stm = $this->db->prepare('SELECT u.username, u.picture_url, eu.user_id, eu.event_id, eu.status, eu.invited_by, (UNIX_TIMESTAMP(eu.invited_at) * 1000) as invited_at FROM user u, guestlist eu WHERE eu.event_id=:id AND u.user_id=eu.user_id ORDER BY u.username DESC');
        $params = array(':id' => $id);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'Guest');
        $stm->execute($params);
        $allGuest = $stm->fetchAll(PDO::FETCH_CLASS);
        /* foreach ($allGuest as $guest) {
          $guest = $this->getUser($guest->id);
          } */
        return $allGuest;
    }

    public function getEventByID($eventID) {
        $stm = $this->db->prepare('SELECT * FROM event WHERE event_id=:eventid');
        $params = array(':eventid' => $eventID);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'Event');
        $stm->execute($params);
        $event = $stm->fetch(PDO::FETCH_CLASS);
        return $event;
    }

    public function getSingleEvent($eventID) {
        $stm = $this->db->prepare('SELECT e.event_id, e.place, e.picture_url as event_picture_url, (UNIX_TIMESTAMP(e.date) * 1000) as date, e.title, e.comment, e.added_by as user_id, u.username, u.picture_url as user_picture_url, e.is_private, (UNIX_TIMESTAMP(e.date_added) * 1000) as added_at from event e, user u WHERE event_id=:eventid AND u.user_id=e.added_by');
        $params = array(':eventid' => $eventID);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'Event');
        $stm->execute($params);
        $event = $stm->fetch(PDO::FETCH_CLASS);
        $event->guestList = $this->getAllGuestFromEvent($eventID);
        $event->grillableList = $this->getAllGrillableFromEvent($eventID);
	$event->place = $this->getLocationByID($event->place);
        return $event;
    }

    public function inviteFriendToEvent($eventID, $userID, $invitedBy) {
        try {
            $stm = $this->db->prepare('INSERT INTO guestlist (user_id, event_id, invited_by, status) VALUES (:userID, :eventID, :invited_by, 1)');
            $params = array(':userID' => $userID, ':eventID' => $eventID, ':invited_by' => $invitedBy);
            $stm->execute($params);
            return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function deleteGuestFromEvent($eventID, $guestID) {
	try {
	    if ($this->deleteResponsibleGuestFromEvent($eventID, "user_id", $guestID)) {
		$stm = $this->db->prepare('DELETE FROM guestlist WHERE event_id=:eventID AND user_id=:guestID');
		$params = array(':eventID' => $eventID, ':guestID' => $guestID);
                $stm->execute($params);
                return Constants::DB_QUERY_SUCCESS;
	    } else {
		return Constants::DB_QUERY_ERROR;
	    }
        } catch (Exception $ex) {
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function deleteResponsibleGuestFromEvent($eventID, $option, $optionID) {
	try {
            $stm = $this->db->prepare('DELETE FROM responsible_guest WHERE event_id=:eventID AND ' . $option . '=:optionID');
            $params = array(':eventID' => $eventID, ':optionID' => $optionID);
            $stm->execute($params);
            return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function addGrillableToEvent($grillable) {
        try {
	    if ($this->isEventGrillable($grillable->event_id, $grillable->grillable_id) == null) {
                $stm = $this->db->prepare('INSERT INTO `event_grillable` (event_id, grillable_id, added_by, requested_amount) VALUES (:eventID, :grillableID, :added_by, :requested_amount)');
		$params = array(':eventID' => $grillable->event_id, ':grillableID' => $grillable->grillable_id, ':added_by' => $grillable->user_id/* $this->getUserIDByUsername($grillable->added_by) */, ':requested_amount' => $grillable->requested_amount);
	    } else {
		$stm = $this->db->prepare('UPDATE event_grillable SET requested_amount=requested_amount + :requested_amount WHERE event_id=:event_id AND grillable_id=:grillable_id');
		$params = array(':event_id' => $grillable->event_id, ':grillable_id' => $grillable->grillable_id, ':requested_amount' => $grillable->requested_amount);
	    }
            $stm->execute($params);
            return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
            echo $ex->getMessage();
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function deleteGrillableFromEvent($eventID, $grillableID) {
	try {
            if ($this->deleteResponsibleGuestFromEvent($eventID, "grillable_id", $grillableID) == Constants::DB_QUERY_SUCCESS) {
                $stm = $this->db->prepare('DELETE FROM event_grillable WHERE event_id=:eventID AND grillable_id=:grillableID');
                $params = array(':eventID' => $eventID, ':grillableID' => $grillableID);
                $stm->execute($params);
                return Constants::DB_QUERY_SUCCESS;
            } else {
                return Constants::DB_QUERY_ERROR;
            }
        } catch (Exception $ex) {
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function isEventGrillable($event_id, $grillable_id) {
	$stm = $this->db->prepare("SELECT g.*, eg.event_id, eg.requested_amount FROM event_grillable eg, grillable g WHERE eg.event_id=:event_id AND eg.grillable_id=:grillable_id");
	$params = array(':event_id' => $event_id, ':grillable_id' => $grillable_id);
	$stm->setFetchMode(PDO::FETCH_CLASS, 'EventGrillable');
	$stm->execute($params);
	$eventGrillable = $stm->fetch(PDO::FETCH_CLASS);
	return $eventGrillable;
    }

    public function getAllGrillableFromEvent($eventID, $userID) {
        $stm = $this->db->prepare("SELECT e.event_id, g.name as name, g.unit, eg.*, u.username as added_by FROM `event_grillable` eg, event e, grillable g, user u WHERE g.grillable_id=eg.grillable_id AND eg.event_id=e.event_id AND eg.event_id=:eventID AND eg.added_by=u.user_id");
        $params = array(':eventID' => $eventID);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'EventGrillable');
        $stm->execute($params);
        $allGrillable = $stm->fetchAll(PDO::FETCH_CLASS);
        foreach ($allGrillable as $grillable) {
            $grillable->responsible_guestList = $this->getResponsibleGuest($eventID, $grillable->grillable_id);
	    $grillable->responsible_amount = $this->getResponsibleAmount($grillable->grillable_id, $eventID);
	    $grillable->is_responsible = $this->isResponsible($grillable->grillable_id, $eventID, $userID);
        }
        return $allGrillable;
    }

    public function isResponsible($grillableID, $eventID, $userID) {
	$stm = $this->db->prepare('SELECT user_id FROM responsible_guest WHERE grillable_id=:grillableID AND event_id=:eventID AND user_id=:userID');
	$params = array(':grillableID' => $grillableID, ':eventID' => $eventID, ':userID' => $userID);
	$stm->execute($params);
	$isResponsible = $stm->fetch(0)[0];
	return $isResponsible > 0;
    }

    public function getResponsibleAmount($grillableID, $eventID) {
	$stm = $this->db->prepare('SELECT sum(responsible_amount) FROM responsible_guest WHERE event_id=:eventID AND grillable_id=:grillableID');
        $params = array(':grillableID' => $grillableID, ':eventID' => $eventID);
	$stm->execute($params);
	$responsibleAmount = $stm->fetch(0)[0];
	return $responsibleAmount > 0 ? $responsibleAmount : 0;
    }

    public function addResponsibleGuest($responsibleGuest) {
	if ($this->isResponsible($responsibleGuest->grillable_id, $responsibleGuest->event_id, $responsibleGuest->user_id)) {
	// update
	    $stm = $this->db->prepare('UPDATE responsible_guest SET responsible_amount=responsible_amount + :responsible_amount WHERE event_id=:eventID AND grillable_id=:grillableID AND user_id=:userID');
            $params = array(':userID' => $responsibleGuest->user_id, ':eventID' => $responsibleGuest->event_id, ':grillableID' => $responsibleGuest->grillable_id, ':responsible_amount' => $responsibleGuest->responsible_amount);
            return $stm->execute($params);
	} else {
            $stm = $this->db->prepare('INSERT INTO responsible_guest (event_id, grillable_id, user_id, responsible_amount) VALUES (:eventID, :grillableID, :userID, :responsible_amount)');
            $params = array(':userID' => $responsibleGuest->user_id, ':eventID' => $responsibleGuest->event_id, ':grillableID' => $responsibleGuest->grillable_id, ':responsible_amount' => $responsibleGuest->responsible_amount);
            return $stm->execute($params);
	}
    }

    public function getResponsibleGuest($eventID, $grillableID) {
        $stm = $this->db->prepare("SELECT u.user_id, u.username, u.picture_url, gg.*  FROM `responsible_guest` gg, user u WHERE gg.grillable_id=:grillableID AND gg.user_id=u.user_id AND gg.event_id=:eventID");
        $params = array(':eventID' => $eventID, ':grillableID' => $grillableID);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'ResponsibleGuest');
        $stm->execute($params);
        $allGuestGrillable = $stm->fetchAll(PDO::FETCH_CLASS);
        return $allGuestGrillable;
    }

    public function getAllCategory() {
        $stm = $this->db->prepare('SELECT * FROM category');
        $stm->setFetchMode(PDO::FETCH_CLASS, 'Category');
        $stm->execute();
        $allCategory = $stm->fetchAll(PDO::FETCH_CLASS);
        foreach ($allCategory as $category) {
            $category->grillableList = $this->getAllGrillableFromCategory($category->category_id);
        }
        return $allCategory;
    }

    public function getAllGrillableFromCategory($id) {
        $stm = $this->db->prepare('SELECT * FROM `grillable` WHERE category_id=:category_id');
        $params = array(':category_id' => $id);
        $stm->setFetchMode(PDO::FETCH_CLASS, 'EventGrillable');
        $stm->execute($params);
        $allGrillable = $stm->fetchAll(PDO::FETCH_CLASS);
        foreach ($allGrillable as $grillable) {
            $grillable->requested_amount = 0;
            $grillable->event_id = 0;
            $grillable->added_by = 0;
            $grillable->responsible_guestList = array();
        }
        return $allGrillable;
    }

    public function changeGuestStatus($eventID, $userID, $status) {
        try {
            $stm = $this->db->prepare('UPDATE guestlist SET status=:status WHERE event_id=:eventID AND user_id=:userID');
            $params = array(':eventID' => $eventID, ':userID' => $userID, ':status' => $status);
            $stm->execute($params);
            return Constants::DB_QUERY_SUCCESS;
        } catch (Exception $ex) {
            return Constants::DB_QUERY_ERROR;
        }
    }

    public function addPost($post) {
	try {
	    //$userID = $this->getUserIDByUsername($post->user_id);
	    $stm = $this->db->prepare('INSERT post (event_id, user_id, message) VALUES (:eventID, :userID, :message)');
            $params = array(':eventID' => $post->event_id, ':userID' => $post->user_id, ':message' => $post->message);
            $stm->execute($params);
	    $fbNot = new FireBaseInterface();
	    $fbNot->sendPost($post->username, $post->message, $this->getAllPostToken($post->event_id));
	    //$fbNot->sendMessage();
	    return Constants::DB_QUERY_SUCCESS;
	} catch (Exception $e) {
print_r($e->getMessage());
	    return Constants::DB_QUERY_ERROR;
	}
    }

    public function getPinboard($eventID) {
	try {
	    $stm = $this->db->prepare('SELECT c.id, c.event_id, c.user_id, u.username, u.picture_url, c.message, c.posted_at FROM post c, user u WHERE c.event_id=:eventID AND u.user_id=c.user_id');
	    $params = array(':eventID' => $eventID);
	    $stm->setFetchMode(PDO::FETCH_CLASS, 'Post');
	    $stm->execute($params);
	    $allPost = $stm->fetchAll(PDO::FETCH_CLASS);
	    return $allPost;
	} catch (Exception $e) {
	    return Constants::DB_QUERY_ERROR;
	}
    }

    public function checkNewEvents($userID, $lastCheck) {
	try {
	    $stm = $this->db->prepare('SELECT DISTINCT e.event_id, e.title, e.picture_url as event_picture_url, e.comment, (UNIX_TIMESTAMP(e.date) * 1000) as date, e.place, e.is_private, e.added_by as user_id, (UNIX_TIMESTAMP(e.date_added) * 1000) as added_at, u.username, u.picture_url as user_picture_url, u.user_id FROM event e, user u WHERE u.user_id=e.added_by AND (UNIX_TIMESTAMP(e.date_added * 1000))>:lastCheck AND (e.added_by=:userid or e.event_id in (SELECT event_id FROM guestlist WHERE user_id=:userid)) ORDER BY date');
            $params = array(':userid' => $userID, ':lastCheck' => $lastCheck);
            $stm->setFetchMode(PDO::FETCH_CLASS, 'Event');
            $stm->execute($params);
            $allEvents = $stm->fetchAll(PDO::FETCH_CLASS);
            foreach ($allEvents as $event) {
//            $event->userAmount = $this->getCountUserFromEvent($event->id) + 1;
                $event->guestList = $this->getAllGuestFromEvent($event->event_id);
                $event->grillableList = $this->getAllGrillableFromEvent($event->event_id, $id);
            }
        //print_r($allEvents);
            return count($allEvents) > 0 ? $allEvents : Constants::NO_VALUE;
	} catch (Exception $e) {
	    echo $e->getMessage();
	    return Constants::DB_QUERY_ERROR;
	}
    }

    public function checkNewFriends($userID, $lastCheck) {
	try {
	    $stm = $this->db->prepare('SELECT * FROM friends WHERE friend_id=:friendID AND status=1 AND (UNIX_TIMESTAMP(added_at * 1000))>:lastCheck');
            $params = array(':friendID' => $userID, ':lastCheck' => $lastCheck);
            $stm->setFetchMode(PDO::FETCH_CLASS, 'Friends');
            $stm->execute($params);
            $allUser = $stm->fetchAll(PDO::FETCH_CLASS);
            $allFriends = null;
            if ($allUser != null) {
                foreach ($allUser as $user) {
                    $friend = $this->getUser($user->user_id);
                    $friend->status = 1;
		    $friend->added_at = $user->added_at;
                    $allFriends[] = $friend;
                }
            }
//return count($allFriends);
            return count($allFriends) > 0 ? $allFriends : Constants::NO_VALUE;
	} catch (Exception $e) {
echo $e->getMessage();
	    return Constants::DB_QUERY_ERROR;
	}
    }

    public function saveToken($userID, $token) {
	try {
	    $stm = $this->db->prepare('UPDATE user SET token=:token WHERE user_id=:userID');
	    $params = array(':userID' => $userID, ':token' => $token);
	    $stm->execute($params);
	    return Constants::DB_QUERY_SUCCESS;
	} catch (Exception $e) {
	    return Constants::DB_QUERY_ERROR;
	}
    }

    public function getAllPostToken($eventID, $notUserID) {
	try {
	    $stm = $this->db->prepare('SELECT token FROM `user` WHERE user_id IN (SELECT user_id From guestlist WHERE event_id=:eventID)');// AND user_id!=:userID)');
	    $params = array(':eventID' => $eventID);//, ':userID' => $notUserID);
	    $stm->execute($params);
	    $allToken = $stm->fetchAll(PDO::FETCH_COLUMN);
	    return $allToken;
	} catch (Exception $e) {
	    return Constants::DB_QUERY_ERROR;
	}
    }

}
